package gov.va.med.mhv.health.web.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.context.RequestContext;
import org.primefaces.event.data.SortEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.web.form.bean.MilitaryHistory;
import gov.va.med.mhv.health.web.util.WebServiceClientUtil;



@ManagedBean
@Component
@Scope("session")
public class MilitaryHistoryController extends AbstractController{
	
	private static final long serialVersionUID = 981887530734048333L;
	
	private static Logger log = LogManager.getLogger(MilitaryHistoryController.class);
	private List<MilitaryHistory> militaryHistories = new ArrayList<MilitaryHistory>();
	private DataTable hrTable;
	private MilitaryHistory selectedMilitaryHistory = new MilitaryHistory();
	private MilitaryHistory newMilitaryHistory = new MilitaryHistory();
	private boolean displayEmptyMessage=false;
	private boolean displayViewMessage=false;
	private static final String MILITARY_HISTORY="militaryHistory";
	private static final String DELETE_MILITARY_HISTORY_RECORD="deleteMilitaryHistory";
	private static final String MILITARY_HISTORY_BY_ID="militaryHistoryByid";
	private Date maxDate = new Date(System.currentTimeMillis());
	
	private String returnPage;
	
	public void init(ComponentSystemEvent event) {
		findUser();
		userprofileId = getUserProfileId();
		hrTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("militaryHistoryForm:militaryHistList");
		if(!FacesContext.getCurrentInstance().isPostback()){
			resetMessages();
			if (userprofileId != null) {
				militaryHistories = findMilitaryHistories(userprofileId);
			}
			setRowsPerPage(10);
		}else{
			if(sortColumn != null && sortBy != null){
				hrTable.setValueExpression("sortBy", sortColumn);
				hrTable.setSortOrder(sortBy);
			} 
		}
		
		Calendar cal = Calendar.getInstance();
		cal.setTime(maxDate);
		cal.set(Calendar.MONTH, 11);
		cal.set(Calendar.DAY_OF_MONTH, 31);
		maxDate = cal.getTime();
		
	}
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}

	private List<MilitaryHistory> findMilitaryHistories(Long userprofileId) {
		List<MilitaryHistory> dtoList = null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(MILITARY_HISTORY).path(userprofileId).accept(CONTENT_TYPE);
		    Response webserviceResponse =client.get();
		    if(webserviceResponse.getStatus() == 200){
				responseReader = new InputStreamReader((InputStream) webserviceResponse.getEntity());
				ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
				if (response.isSuccess()) {
					String militaryHistoryJson = gson.toJson(response.getPojoObject());
					Type type = new TypeToken<List<MilitaryHistory>>() {}.getType();
					dtoList = gson.fromJson(militaryHistoryJson, type);
					
					log.debug("Military History Records :" + dtoList.size());
				} else {
					log.error("Error in Find Military History Records");
					WebServiceClientUtil.showErrorMessage();
				}
		    }else{
		    	log.error(WebServiceClientUtil.formatErrorMessage(client, webserviceResponse));
		    	WebServiceClientUtil.showErrorMessage();
		    }
		} catch (Exception e) {
			log.error("Error in Find Military History Records:", e.getMessage());
			WebServiceClientUtil.showErrorMessage();
		}finally{
			responseReader=null;
		}

		if(dtoList==null || dtoList.isEmpty()) {
			displayEmptyMessage=true;
			displayViewMessage=false;
		}
		else {
			displayViewMessage=true;
			displayEmptyMessage=false;			
		}
		
		
		return dtoList;
	}
	
	public String showDetail(MilitaryHistory militaryHistory) {
		resetMessages();
		returnPage = "militaryHistory";
		selectedMilitaryHistory = militaryHistory;
		return "militaryHistory";
	}
	
	public String returnToCallingPage() {
		resetMessages();
		returnPage = (null != returnPage && returnPage.trim().length() > 0) ? returnPage : "militaryHistoryList";
		return returnPage;
	}
	
	public String editDisplay(MilitaryHistory militaryHistory) {
		resetMessages();
		selectedMilitaryHistory = militaryHistory;
		return "editMilitaryHistoryDisplay";
	}

	public String deleteDisplay(MilitaryHistory militaryHistory) {
		resetMessages();
		selectedMilitaryHistory = militaryHistory;
		return "deleteMilitaryHistoryDisplay";
	}
	
	public String backToList(){
		resetMessages();
		return "militaryHistoryList";
	}
	
	public String addDisplay() {
		resetMessages();
		newMilitaryHistory=new MilitaryHistory();
		return "addMilitaryHistoryDisplay";
	}
	
	//TODO: change the navigation handler
	public String dashboardAddDisplay() {
		resetMessages();
		findUser();
		newMilitaryHistory=new MilitaryHistory();
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../heartrate/addHRDisplay.xhtml");
		return null;
	}
	
	//TODO:change the navigation handler
	public String showDahBoardDetail() {
		resetMessages();
		findUser();
		String hhid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("hhid");
		if (hhid != null) {
			Long id = Long.valueOf(hhid);
			selectedMilitaryHistory=findMilitaryHistoryById(id);
		}	
		FacesContext context = FacesContext.getCurrentInstance();
		context.getApplication().getNavigationHandler().
		           handleNavigation(context, null, "../family/family.xhtml");
		return null;
	}

	
	private MilitaryHistory findMilitaryHistoryById(Long id) {
		MilitaryHistory dto=null;
		Reader responseReader=null;
		try {
			Gson gson = getGson();
		    WebClient client= getWebClient().path(MILITARY_HISTORY_BY_ID).path(id).accept(CONTENT_TYPE);
			responseReader = new InputStreamReader((InputStream) client.get().getEntity());
			ResponseUtil response = gson.fromJson(responseReader,ResponseUtil.class);
			if (response.isSuccess()) {
				String militaryHistoryJson = gson.toJson(response.getPojoObject());
				dto = gson.fromJson(militaryHistoryJson, MilitaryHistory.class);
			} else {
				log.error("Error in Find Military History Record By id");
				
				FacesContext.getCurrentInstance().addMessage(null,
						new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
			}
		} catch (Exception e) {
			log.error("Error in Find  Health History Record By id:", e);
			FacesContext.getCurrentInstance().addMessage(null,
					new FacesMessage(FacesMessage.SEVERITY_ERROR,ERR_PRCS_RQST,ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return dto;
	}


	public String delete() {
		String outcome=null;
		Reader responseReader=null;
		String mhid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("mhid");
		try{
			if (mhid != null) {
				Long id = Long.valueOf(mhid);
				Gson gson = getGsonTimeStamp();
				WebClient client=getWebClient().path(DELETE_MILITARY_HISTORY_RECORD).path(id).accept(CONTENT_TYPE);
				responseReader = new InputStreamReader((InputStream) client.delete().getEntity());
				ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
				if (!response.isSuccess()) {
				log.debug("Failed to Delete Health History Record" , response.getFailureMessage());
					
					FacesContext.getCurrentInstance().addMessage(null, 
							new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
				}else{
					deleteMessage = true;
					militaryHistories = findMilitaryHistories(userprofileId);
					outcome="militaryHistoryList";
				}
			}
		}catch(Exception e){
			log.error("Failed to Delete Health History Record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}

	public String save() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response =saveMilitaryHistory(responseReader);
			if(response.isSuccess()){
				outcome="militaryHistoryList";
				saveMessage = true;
				militaryHistories = findMilitaryHistories(userprofileId);
			}
		}catch(Exception e){
			log.error("Failed to Save Military History Record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		
		
		return outcome;
	}

	public ResponseUtil saveMilitaryHistory(Reader responseReader) {
		String mhid = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("mhid");
		MilitaryHistory militaryRecord=null;
		if (mhid != null) {
			militaryRecord=getSelectedMilitaryHistory();
		}else{
			militaryRecord=getNewMilitaryHistory();
		}
		Gson gson =getGson();
		WebClient client= getWebClient().path(MILITARY_HISTORY).accept(CONTENT_TYPE).type(CONTENT_TYPE);
		
		militaryRecord = prepareMilitaryHistory(militaryRecord);
		String militaryRecordJson = gson.toJson(militaryRecord);
		responseReader = new InputStreamReader((InputStream) client.post(militaryRecordJson).getEntity());
		ResponseUtil response = gson.fromJson(responseReader, ResponseUtil.class);
		
		if(!response.isSuccess()){
			Map<String, String> map = response.getValidationErrors();
			for (Map.Entry<String, String> entry : map.entrySet()) {
				if (null != entry) {
					log.debug("entry.getKey() : " + entry.getKey());
					log.debug("entry.getValue() : " + entry.getValue());
				}
				FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, entry.getValue(), entry.getValue()));
			}
		}
		
				
		return response;
	}


	public MilitaryHistory prepareMilitaryHistory(MilitaryHistory militaryHistory) {
		militaryHistory.setUserprofileId(getUserProfileId());
		return militaryHistory;
	}

	public String saveAndAdd() {
		String outcome=null;
		Reader responseReader=null;
		try{
			ResponseUtil response=saveMilitaryHistory(responseReader);
			if(response.isSuccess()){
				outcome="addMilitaryHistoryDisplay";
				saveAndAddMessage = true;
				militaryHistories = findMilitaryHistories(userprofileId);
				newMilitaryHistory=new MilitaryHistory();
			}

		}catch(Exception e){
			log.error("Failed to Save Health History Record record",e);
			
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}finally{
			responseReader=null;
		}
		return outcome;
	}
	
	public String printerFriendlySummary(){
		hrTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("militaryHistoryForm:militaryHistList");
		return "printMilitaryHistorySummary";
	}

	public List<MilitaryHistory> getMilitaryHistories() {
		return militaryHistories;
	}

	public void setMilitaryHistories(List<MilitaryHistory> militaryHistories) {
		this.militaryHistories = militaryHistories;
	}

	public DataTable getHrTable() {
		return hrTable;
	}

	public void setHrTable(DataTable hRTable) {
		this.hrTable = hRTable;
	}

	public MilitaryHistory getSelectedMilitaryHistory() {
		return selectedMilitaryHistory;
	}

	public void setSelectedMilitaryHistory(MilitaryHistory selectedMilitaryHistory) {
		this.selectedMilitaryHistory = selectedMilitaryHistory;
	}

	public MilitaryHistory getNewMilitaryHistory() {
		return newMilitaryHistory;
	}

	public void setNewMilitaryHistory(MilitaryHistory newMilitaryHistory) {
		this.newMilitaryHistory = newMilitaryHistory;
	}
	public Date getMaxDate() {
		return maxDate;
	}
	public void setMaxDate(Date maxDate) {
		this.maxDate = maxDate;
	}
	public boolean isDisplayEmptyMessage() {
		return displayEmptyMessage;
	}
	public void setDisplayEmptyMessage(boolean displayEmptyMessage) {
		this.displayEmptyMessage = displayEmptyMessage;
	}
	public boolean isDisplayViewMessage() {
		return displayViewMessage;
	}
	public void setDisplayViewMessage(boolean displayViewMessage) {
		this.displayViewMessage = displayViewMessage;
	}
	
}

